unit udm;

interface

uses
  SysUtils, Classes, DB, DBTables, Dialogs, DBCtrls, Controls, StdCtrls, ExtCtrls,
  MemDS, DBAccess, MyAccess;

type
  TSelectLabel = class(TLabel)
    public
      vDay    : integer;
      vLesson : integer;
  end;

type
  Tdm = class(TDataModule)
    sClass: TDataSource;
    sSubject: TDataSource;
    sTeacher: TDataSource;
    sRoom: TDataSource;
    sTutorArrange: TDataSource;
    sDetail: TDataSource;
    MySQL94: TMyConnection;
    tClass: TMyTable;
    qSubject: TMyTable;
    tTeacher: TMyTable;
    qRoom: TMyTable;
    tTutorArrange: TMyTable;
    tDetail: TMyTable;
    qTeacherNbr: TMyQuery;
    qRoomid: TLargeintField;
    qRoomcode: TWideStringField;
    qRoomname: TWideStringField;
    tTutorArrangeClassID: TWideStringField;
    tTutorArrangeSubjID: TLargeintField;
    tTutorArrangeSubjName: TWideStringField;
    tTutorArrangeTchrID: TWideStringField;
    tTutorArrangeRoomID: TWideStringField;
    tTutorArrangeNbr: TLargeintField;
    tTutorArrangeRoomStr: TStringField;
    qSubjectid: TLargeintField;
    qSubjectcode: TWideStringField;
    qSubjectname: TWideStringField;
    tClassid: TWideStringField;
    tDetailid: TLargeintField;
    tDetailClassCode: TWideStringField;
    tDetailSubjectID: TLargeintField;
    tDetailSubjectCode: TWideStringField;
    tDetailTeacherID: TLargeintField;
    tDetailTeacherCode: TWideStringField;
    tDetailRoomCode: TWideStringField;
    tDetailNbr: TWideStringField;
    tDetailDayCode: TLargeintField;
    tDetailLessonCode: TLargeintField;
    tDetailFlag: TBooleanField;
    tTutorArrangeSubj: TStringField;
    tTutorArrangeTchr: TStringField;
    tTutorArrangeTchrCode: TStringField;
    qTeacherList: TMyQuery;
    tTeachercode: TWideStringField;
    tTeachername: TWideStringField;
    tTeacherid: TLargeintField;
    tTeachernbr: TLargeintField;
    tDetailExLesson: TLargeintField;
    tTeacherLastYear: TLargeintField;
    tTutorArrangeSchYear: TLargeintField;
    tDetailSchYear: TLargeintField;
    tClassNbr: TIntegerField;
    tClass: TIntegerField;
    tClass^: TIntegerField;
    tClassƾ: TIntegerField;
    tClass`: TIntegerField;
    tClass: TIntegerField;
    tClass: TIntegerField;
    tClass|: TIntegerField;
    tClassq: TIntegerField;
    tClassw: TIntegerField;
    tClassϮ: TIntegerField;
    tClassq: TIntegerField;
    tClassƤ@: TIntegerField;
    tClassƤG: TIntegerField;
    tClassƤT: TIntegerField;
    tClassƥ|: TIntegerField;
    tClassƤ: TIntegerField;
    tClassF: TIntegerField;
    tClassMaxNbr: TIntegerField;
    tClassSchYear: TIntegerField;
    procedure ttClassAfterScroll(DataSet: TDataSet);
    procedure ttTutorArrangeBeforeDelete(DataSet: TDataSet);
    procedure ttTutorArrangeAfterPost(DataSet: TDataSet);
    procedure ttTutorArrangeBeforePost(DataSet: TDataSet);
    procedure ttClassBDEDesignerChange(Sender: TField);
    procedure tDetailBeforePost(DataSet: TDataSet);
    procedure tDetailTeacherCodeChange(Sender: TField);
    procedure tClassNewRecord(DataSet: TDataSet);
    procedure tTutorArrangeFilterRecord(DataSet: TDataSet; var Accept: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  maxDay         = 5;
  maxClass       = 30;
  maxSubject     = 20;
  maxColumn      = maxClass;
  maxRow         = 9;
  Days           : array [1..maxDay] of string = ('P@', 'PG', 'PT', 'P|', 'P');
  EDays          : array [1..maxDay] of string = ('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday');
  defWidth       = 23;
  defHeight      = 60;
  defClassHeight = 20;

type
  DetailRecord = record
    RecID       : integer;
    DayCode     : integer;
    ClassID     : integer;
    ClassCode   : string[3];
    LessonCode  : integer;
    SubjectID   : integer;
    SubjectCode : string[2];
    TeacherID   : integer;
    TeacherCode : string[2];
    RoomCode    : string[4];
  end;

var
  DayLabel    : array [1..maxDay] of TLabel;
  DayPanel    : TPanel;
  ClassLabel  : array [1..maxClass] of TLabel;
  TeacherLabel : array [1..maxClass*2] of TLabel;
  DNbrLabel   : array [1..maxRow] of TLabel;
  CNbrLabel   : array [1..maxRow] of TLabel;
  TeacherPanel : TPanel;
  ClassPanel  : TPanel;
  ClassAccessPanel : TPanel;
  TeacherAccessPanel : TPanel;
  DetailPanel : array [1..maxClass, 1..maxRow*maxColumn] of TPanel;
  Details     : array [1..maxDay*maxClass*maxRow] of DetailRecord;
  SubjectReduction : array [1..maxSubject] of integer;
  ClassFill   : array [1..maxDay, 1..maxRow] of Boolean;
  ClassItem   : array [1..maxDay, 1..maxRow] of TLabel;
  AccessSubjectLabel : array [1..maxSubject] of TLabel;
  AccessTeacherLabel : array [1..maxSubject] of TLabel;
  AccessNbrLabel     : array [1..maxSubject] of TLabel;
  AccessRoomLabel    : array [1..maxSubject] of TLabel;
  TAccessSubjectLabel : array [1..maxSubject] of TLabel;
  TAccessClassLabel : array [1..maxSubject] of TLabel;
  TAccessNbrLabel     : array [1..maxSubject] of TLabel;
  TAccessRoomLabel    : array [1..maxSubject] of TLabel;
  mClass      : integer;
  mDetail     : integer;
  mTeacher    : integer;
  cDay        : integer;
  cClass      : string[3];
  cLesson     : integer;
  cTeacher    : string[2];
  UsedTeacher : string;
  UsedRoom    : string;
  thisDay     : integer;
  thisLesson  : integer;
  thisClass   : string[3];
  thisSubject : string[2];
  thisTeacher : string[2];
  thisRoom    : string[4];
  ClassDisplay   : array [1..maxClass*maxRow] of TLabel;
  SubjectDisplay : array [1..maxClass*maxRow] of TLabel;
  TeacherDisplay : array [1..maxClass*maxRow] of TLabel;
  RoomDisplay    : array [1..maxClass*maxRow] of TLabel;
  LessonDisplay  : array [1..maxClass*maxRow] of integer;
  DayDisplay     : array [1..maxClass*maxRow] of integer;
  TeacherList    : string;
  vSchYear       : integer;

var
  dm: Tdm;

implementation

{$R *.dfm}

procedure Tdm.tClassNewRecord(DataSet: TDataSet);
begin
  DataSet.FieldByName('SchYear').AsInteger := vSchYear;
end;

procedure Tdm.tDetailBeforePost(DataSet: TDataSet);
begin
//  ShowMessage('It changed');
end;

procedure Tdm.tDetailTeacherCodeChange(Sender: TField);
begin
//  ShowMessage('It change too');
end;

procedure Tdm.ttClassAfterScroll(DataSet: TDataSet);
begin
  if DataSet.Active then begin
    tTutorArrange.Filter   := 'ClassID = '''+DataSet.FieldByName('ID').AsString+'''';
    tTutorArrange.Filtered := true;
  end;
end;

procedure Tdm.ttTutorArrangeBeforeDelete(DataSet: TDataSet);
begin
//  if MessageDlg('-Sure to delete?', mtConfirmation, [mbYes, mbNo], 0) <> mrYes then abort;
end;

procedure Tdm.ttTutorArrangeAfterPost(DataSet: TDataSet);
var Bk:TBookmark;
    N: integer;
begin
  Bk := DataSet.GetBookmark;
  DataSet.DisableControls;
  if DataSet.IsEmpty then begin
    tClass.edit;
    tClass.FieldByName('Nbr').AsInteger := 0;
    tClass.post;
  end
  else begin
    DataSet.first;
    N := 0;
    while not DataSet.eof do begin
      N := N + DataSet.FieldByName('Nbr').AsInteger;
      DataSet.next;
    end;
    tClass.edit;
    tClass.FieldByName('Nbr').AsInteger := n;
    tClass.post;
  end; { end DataSet is empty }
  DataSet.GotoBookmark(Bk);
  DataSet.FreeBookmark(Bk);
  DataSet.EnableControls;
  dm.qTeacherNbr.Close;
  dm.qTeacherNbr.ParamByName('vTeacher').AsString := DataSet.FieldByName('TchrID').AsString;
  dm.qTeacherNbr.Open;
  if dm.tTeacher.Locate('Name', DataSet.FieldByName('TchrID').AsString, []) then begin
    dm.tTeacher.edit;
    dm.tTeacher.FieldByName('Nbr').AsInteger := dm.qTeacherNbr.FieldByName('NbrTotal').AsInteger;
    dm.tTeacher.Post;
  end;
end;

procedure Tdm.ttTutorArrangeBeforePost(DataSet: TDataSet);
var N:integer;
begin
  N := DataSet.FieldByName('Nbr').AsInteger;
  if N < 1 then DataSet.FieldByName('Nbr').AsInteger := 1
  else if N > 9 then DataSet.FieldByName('Nbr').AsInteger := 9;
end;

procedure Tdm.tTutorArrangeFilterRecord(DataSet: TDataSet; var Accept: Boolean);
begin
  Accept := (DataSet.FieldByName('SchYear').AsInteger = vSchYear);
end;

procedure Tdm.ttClassBDEDesignerChange(Sender: TField);
begin
  with tClass do begin
  FieldByName('MaxNbr').AsInteger
    := FieldByName('').AsInteger
     + FieldByName('^').AsInteger
     + FieldByName('ƾ').AsInteger
     + FieldByName('`').AsInteger
     + FieldByName('').AsInteger
     + FieldByName('').AsInteger
     + FieldByName('|').AsInteger
     + FieldByName('q').AsInteger
     + FieldByName('w').AsInteger
     + FieldByName('Ϯ').AsInteger
     + FieldByName('q').AsInteger;
  end;
end;

end.
